const { config } = require("dotenv");
const express = require("express");
const morgan = require("morgan");
const cookieParser = require("cookie-parser");
const axios = require('axios');
const cors = require("cors");
const http = require("http");
const path = require("path");
const MainRouter = require("./app/routers");
const errorHandlerMiddleware = require("./app/middlewares/error_middleware");
// const whatsapp = require("wa-multi-session");
const whatsapp = require("./dist/index");

config();

var app = express();
app.use(morgan("dev"));
app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.set("view engine", "ejs");
// Public Path
app.use("/p", express.static(path.resolve("public")));
app.use("/p/*", (req, res) => res.status(404).send("Media Not Found"));

app.use(MainRouter);

app.use(errorHandlerMiddleware);

const PORT = process.env.PORT || "5000";
app.set("port", PORT);
var server = http.createServer(app);
server.on("listening", () => console.log("APP IS RUNNING ON PORT " + PORT));

server.listen(PORT);

// whatsapp.onMessageReceived(async (msg) => {
//   if (msg.key.fromMe || msg.key.remoteJid.includes("status")) return;
//   await whatsapp.readMessage({
//     sessionId: msg.sessionId,
//     key: msg.key,
//   });
//   await whatsapp.sendTyping({
//     sessionId: msg.sessionId,
//     to: msg.key.remoteJid,
//     duration: 1000,
//   });

//   if(msg.message.conversation!=''){
//      var text_andro = msg.message.conversation;
//   }else{
//     var text_web = msg.message.extendedTextMessage.text;
//   }
//   let hp = msg.key.remoteJid;
//   console.log(msg.message.conversation);
//   if(text_andro=='Cek status' || text_web=='Cek status'){
//      const response = await axios.get("https://script.google.com/macros/s/AKfycbwLe6KqHy1qLMsk9Wg513VAn21WE_90U8Ajeubf2O8nhxQ0CNHULYRSqJ4XMyEGDyQD/exec?whatsapp="+hp.replace('@s.whatsapp.net',''));
//      if(response.data.success==true){
//       await whatsapp.sendTextMessage({
//         sessionId: msg.sessionId,
//         to: msg.key.remoteJid,
//         text: "Terimakasih bapak/ibu *"+response.data.data.nama+"*  \n Berikut status service motor anda \n \n  Nomor Polisi : *"+response.data.data.no_plat+"* \n Nama : *"+response.data.data.nama+"* \n Total Bayar : *"+response.data.data.total_bayar+"* \n Status  : *"+response.data.data.status+"* \n  \n Terimasih sudah mempercayakan kendaraan anda kepada kami.",
//         answering: msg, // for quoting message
//       });
//     }else{
//       await whatsapp.sendTextMessage({
//       sessionId: msg.sessionId,
//       to: msg.key.remoteJid,
//       text: "Mohon maaf anda belum melakukan order.",
//       answering: msg, // for quoting message
//     });
//     }
//   }else{
//     await whatsapp.sendTextMessage({
//       sessionId: msg.sessionId,
//       to: msg.key.remoteJid,
//       text: "Hi ! *"+msg.pushName+"* Selamat datang di notifikasi whatsapp NOTIFIKASI MIN 1 JOMBANG \n \n Ini bot pintar ! \n  \n  Silahkan tulis kata `*Cek Status*` untuk cek status service kendaraan anda.",
//       answering: msg, // for quoting message
//     });
//   }
// });

whatsapp.onConnected((session) => {
  console.log("connected => ", session);
});

whatsapp.onDisconnected((session) => {
  console.log("disconnected => ", session);
});

whatsapp.onConnecting((session) => {
  console.log("connecting => ", session);
});

whatsapp.loadSessionsFromStorage();
