"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onPairingCode = exports.onMessageUpdate = exports.onConnecting = exports.onDisconnected = exports.onConnected = exports.onQRUpdated = exports.onMessageReceived = exports.loadSessionsFromStorage = exports.getSession = exports.getAllSession = exports.deleteSession = exports.startWhatsapp = exports.startSessionWithPairingCode = exports.startSession = void 0;
const baileys_1 = __importStar(require("@whiskeysockets/baileys"));
// import pino from "pino";
const pino = require('pino')();
const axios = require('axios');
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const Defaults_1 = require("../Defaults");
const save_media_1 = require("../Utils/save-media");
const Error_1 = require("../Error");
const message_status_1 = require("../Utils/message-status");
const sessions = new Map();
const callback = new Map();
const retryCount = new Map();
let partisipan;
const startSession = (sessionId = "mysession", options = { printQR: true }) => __awaiter(void 0, void 0, void 0, function* () {
    if (isSessionExistAndRunning(sessionId))
        throw new Error_1.WhatsappError(Defaults_1.Messages.sessionAlreadyExist(sessionId));
    const logger = pino.child({ level: "silent" });
    let group;
    const { version } = yield (0, baileys_1.fetchLatestBaileysVersion)();
    const startSocket = () => __awaiter(void 0, void 0, void 0, function* () {
        const { state, saveCreds } = yield (0, baileys_1.useMultiFileAuthState)(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX));
        const sock = (0, baileys_1.default)({
            version,
            printQRInTerminal: options.printQR,
            auth: state,
            logger,
            markOnlineOnConnect: false,
            browser: baileys_1.Browsers.ubuntu("Chrome"),
        });
        sessions.set(sessionId, Object.assign({}, sock));
        try {
            sock.ev.process((events) => __awaiter(void 0, void 0, void 0, function* () {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
                const contact = events['messaging-history.set'];
                if (events["connection.update"]) {
                    const update = events["connection.update"];
                    const { connection, lastDisconnect } = update;
                    if (update.qr) {
                        (_a = callback.get(Defaults_1.CALLBACK_KEY.ON_QR)) === null || _a === void 0 ? void 0 : _a({
                            sessionId,
                            qr: update.qr
                        });
                    }
                    if (connection == "connecting") {
                        (_b = callback.get(Defaults_1.CALLBACK_KEY.ON_CONNECTING)) === null || _b === void 0 ? void 0 : _b(sessionId);
                    }
                    if (connection === "close") {
                        const code = (_d = (_c = lastDisconnect === null || lastDisconnect === void 0 ? void 0 : lastDisconnect.error) === null || _c === void 0 ? void 0 : _c.output) === null || _d === void 0 ? void 0 : _d.statusCode;
                        let retryAttempt = (_e = retryCount.get(sessionId)) !== null && _e !== void 0 ? _e : 0;
                        let shouldRetry;
                        if (code != baileys_1.DisconnectReason.loggedOut && retryAttempt < 10) {
                            shouldRetry = true;
                        }
                        if (shouldRetry) {
                            retryAttempt++;
                        }
                        if (shouldRetry) {
                            retryCount.set(sessionId, retryAttempt);
                            startSocket();
                        }
                        else {
                            retryCount.delete(sessionId);
                            (0, exports.deleteSession)(sessionId);
                            (_f = callback.get(Defaults_1.CALLBACK_KEY.ON_DISCONNECTED)) === null || _f === void 0 ? void 0 : _f(sessionId);
                        }
                    }
                    if (connection == "open") {
                        let session = sessionId;
                        try {
                            let getGroups = yield sock.groupFetchAllParticipating();
                            partisipan = JSON.stringify(Object.entries(getGroups).slice(0).map(entry => entry[1]));
                            if (getGroups) {
                                const dir = path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_LOG);
                                fs_1.default.writeFile(dir + "/" + sessionId + ".json", partisipan, 'utf-8', function (err) {
                                    return __awaiter(this, void 0, void 0, function* () {
                                        if (err) {
                                            console.log('error');
                                        }
                                        const filePath = dir + '/' + sessionId + '.json';
                                        fs_1.default.readFile(filePath, 'utf8', function (err, data) {
                                            return __awaiter(this, void 0, void 0, function* () {
                                                const result = yield axios({
                                                    method: "post",
                                                    url: "http://localhost/chatwabot/sessions/set-log",
                                                    data: { session_id: sessionId, log: data },
                                                    headers: { "Content-Type": "application/json" },
                                                });
                                                // console.log(result.data);
                                            });
                                        });
                                    });
                                });
                            }
                            //Passing contact
                        }
                        catch (error) {
                            console.log('error');
                        }
                        retryCount.delete(sessionId);
                        (_g = callback.get(Defaults_1.CALLBACK_KEY.ON_CONNECTED)) === null || _g === void 0 ? void 0 : _g(sessionId, partisipan);
                    }
                }
                if (events["creds.update"]) {
                    yield saveCreds();
                }
                if (events["messages.update"]) {
                    const msg = events["messages.update"][0];
                    const data = Object.assign({ sessionId: sessionId, messageStatus: (0, message_status_1.parseMessageStatusCodeToReadable)(msg.update.status) }, msg);
                    (_h = callback.get(Defaults_1.CALLBACK_KEY.ON_MESSAGE_UPDATED)) === null || _h === void 0 ? void 0 : _h(sessionId, data);
                }
                if (events['messaging-history.set']) {
                    const { chats, contacts, messages, isLatest } = events['messaging-history.set'];
                    console.log(contacts);
                    const listContact = JSON.stringify(contacts);
                    const listChats = JSON.stringify(chats);
                    const listMessages = JSON.stringify(messages);
                    const dir = path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_LOG);
                    fs_1.default.writeFile(dir + "/contacts_" + sessionId + ".json", listContact, 'utf-8', function (err) {
                        return __awaiter(this, void 0, void 0, function* () {
                            if (err) {
                                console.log('error create contacts');
                            }
                        });
                    });
                    fs_1.default.writeFile(dir + "/chats_" + sessionId + ".json", listChats, 'utf-8', function (err) {
                        return __awaiter(this, void 0, void 0, function* () {
                            if (err) {
                                console.log('error create chat');
                            }
                        });
                    });
                    fs_1.default.writeFile(dir + "/messages_" + sessionId + ".json", listMessages, 'utf-8', function (err) {
                        return __awaiter(this, void 0, void 0, function* () {
                            if (err) {
                                console.log('error create messsage');
                            }
                        });
                    });
                    console.log(`recv ${chats.length} chats, ${contacts.length} contacts, ${messages.length} msgs (is latest: ${isLatest})`);
                }
                if (events["messages.upsert"]) {
                    const msg = (_j = events["messages.upsert"]
                        .messages) === null || _j === void 0 ? void 0 : _j[0];
                    msg.sessionId = sessionId;
                    msg.saveImage = (path) => (0, save_media_1.saveImageHandler)(msg, path);
                    msg.saveVideo = (path) => (0, save_media_1.saveVideoHandler)(msg, path);
                    msg.saveDocument = (path) => (0, save_media_1.saveDocumentHandler)(msg, path);
                    (_k = callback.get(Defaults_1.CALLBACK_KEY.ON_MESSAGE_RECEIVED)) === null || _k === void 0 ? void 0 : _k(Object.assign({}, msg));
                }
            }));
            return sock;
        }
        catch (error) {
            // console.log("SOCKET ERROR", error);
            return sock;
        }
    });
    return startSocket();
});
exports.startSession = startSession;
// console.log(group);
const startSessionWithPairingCode = (sessionId, options) => __awaiter(void 0, void 0, void 0, function* () {
    if (isSessionExistAndRunning(sessionId))
        throw new Error_1.WhatsappError(Defaults_1.Messages.sessionAlreadyExist(sessionId));
    const logger = pino({ level: "silent" });
    const { version } = yield (0, baileys_1.fetchLatestBaileysVersion)();
    const startSocket = () => __awaiter(void 0, void 0, void 0, function* () {
        var _l;
        const { state, saveCreds } = yield (0, baileys_1.useMultiFileAuthState)(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX));
        const sock = (0, baileys_1.default)({
            version,
            printQRInTerminal: false,
            auth: state,
            logger,
            markOnlineOnConnect: false,
            browser: baileys_1.Browsers.ubuntu("Chrome"),
        });
        sessions.set(sessionId, Object.assign({}, sock));
        try {
            if (!sock.authState.creds.registered) {
                console.log("first time pairing");
                const code = yield sock.requestPairingCode(options.phoneNumber);
                console.log(code);
                (_l = callback.get(Defaults_1.CALLBACK_KEY.ON_PAIRING_CODE)) === null || _l === void 0 ? void 0 : _l(sessionId, code);
            }
            sock.ev.process((events) => __awaiter(void 0, void 0, void 0, function* () {
                var _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
                if (events["connection.update"]) {
                    const update = events["connection.update"];
                    const { connection, lastDisconnect } = update;
                    if (update.qr) {
                        (_m = callback.get(Defaults_1.CALLBACK_KEY.ON_QR)) === null || _m === void 0 ? void 0 : _m({
                            sessionId,
                            qr: update.qr,
                        });
                    }
                    if (connection == "connecting") {
                        (_o = callback.get(Defaults_1.CALLBACK_KEY.ON_CONNECTING)) === null || _o === void 0 ? void 0 : _o(sessionId);
                    }
                    if (connection === "close") {
                        const code = (_q = (_p = lastDisconnect === null || lastDisconnect === void 0 ? void 0 : lastDisconnect.error) === null || _p === void 0 ? void 0 : _p.output) === null || _q === void 0 ? void 0 : _q.statusCode;
                        let retryAttempt = (_r = retryCount.get(sessionId)) !== null && _r !== void 0 ? _r : 0;
                        let shouldRetry;
                        if (code != baileys_1.DisconnectReason.loggedOut && retryAttempt < 10) {
                            shouldRetry = true;
                        }
                        if (shouldRetry) {
                            retryAttempt++;
                        }
                        if (shouldRetry) {
                            retryCount.set(sessionId, retryAttempt);
                            startSocket();
                        }
                        else {
                            retryCount.delete(sessionId);
                            (0, exports.deleteSession)(sessionId);
                            (_s = callback.get(Defaults_1.CALLBACK_KEY.ON_DISCONNECTED)) === null || _s === void 0 ? void 0 : _s(sessionId);
                        }
                    }
                    if (connection == "open") {
                        retryCount.delete(sessionId);
                        (_t = callback.get(Defaults_1.CALLBACK_KEY.ON_CONNECTED)) === null || _t === void 0 ? void 0 : _t(sessionId);
                    }
                }
                if (events["creds.update"]) {
                    yield saveCreds();
                }
                if (events["messages.update"]) {
                    const msg = events["messages.update"][0];
                    const data = Object.assign({ sessionId: sessionId, messageStatus: (0, message_status_1.parseMessageStatusCodeToReadable)(msg.update.status) }, msg);
                    (_u = callback.get(Defaults_1.CALLBACK_KEY.ON_MESSAGE_UPDATED)) === null || _u === void 0 ? void 0 : _u(sessionId, data);
                }
                if (events["messages.upsert"]) {
                    const msg = (_v = events["messages.upsert"]
                        .messages) === null || _v === void 0 ? void 0 : _v[0];
                    msg.sessionId = sessionId;
                    msg.saveImage = (path) => (0, save_media_1.saveImageHandler)(msg, path);
                    msg.saveVideo = (path) => (0, save_media_1.saveVideoHandler)(msg, path);
                    msg.saveDocument = (path) => (0, save_media_1.saveDocumentHandler)(msg, path);
                    (_w = callback.get(Defaults_1.CALLBACK_KEY.ON_MESSAGE_RECEIVED)) === null || _w === void 0 ? void 0 : _w(Object.assign({}, msg));
                }
                if (events["groups.upsert"]) {
                    const msg = events["groups.upsert"];
                    console.log(msg);
                }
            }));
            return sock;
        }
        catch (error) {
            // console.log("SOCKET ERROR", error);
            return sock;
        }
    });
    return startSocket();
});
exports.startSessionWithPairingCode = startSessionWithPairingCode;
/**
 * @deprecated Use startSession method instead
 */
exports.startWhatsapp = exports.startSession;
const deleteSession = (sessionId) => __awaiter(void 0, void 0, void 0, function* () {
    const session = (0, exports.getSession)(sessionId);
    try {
        yield (session === null || session === void 0 ? void 0 : session.logout());
    }
    catch (error) { }
    session === null || session === void 0 ? void 0 : session.end(undefined);
    sessions.delete(sessionId);
    const dir = path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX);
    if (fs_1.default.existsSync(dir)) {
        fs_1.default.rmSync(dir, { force: true, recursive: true });
    }
});
exports.deleteSession = deleteSession;
const getAllSession = () => Array.from(sessions.keys());
exports.getAllSession = getAllSession;
const getSession = (key) => sessions.get(key);
exports.getSession = getSession;
const isSessionExistAndRunning = (sessionId) => {
    if (fs_1.default.existsSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME)) &&
        fs_1.default.existsSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX)) &&
        fs_1.default.readdirSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX)).length &&
        (0, exports.getSession)(sessionId)) {
        return true;
    }
    return false;
};
const shouldLoadSession = (sessionId) => {
    if (fs_1.default.existsSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME)) &&
        fs_1.default.existsSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX)) &&
        fs_1.default.readdirSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME, sessionId + Defaults_1.CREDENTIALS.PREFIX)).length &&
        !(0, exports.getSession)(sessionId)) {
        return true;
    }
    return false;
};
const loadSessionsFromStorage = () => {
    if (!fs_1.default.existsSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME))) {
        fs_1.default.mkdirSync(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME));
    }
    fs_1.default.readdir(path_1.default.resolve(Defaults_1.CREDENTIALS.DIR_NAME), (err, dirs) => __awaiter(void 0, void 0, void 0, function* () {
        if (err) {
            throw err;
        }
        for (const dir of dirs) {
            const sessionId = dir.split("_")[0];
            if (!shouldLoadSession(sessionId))
                continue;
            (0, exports.startSession)(sessionId);
        }
    }));
};
exports.loadSessionsFromStorage = loadSessionsFromStorage;
const onMessageReceived = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_MESSAGE_RECEIVED, listener);
};
exports.onMessageReceived = onMessageReceived;
const onQRUpdated = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_QR, listener);
};
exports.onQRUpdated = onQRUpdated;
const onConnected = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_CONNECTED, listener);
};
exports.onConnected = onConnected;
const onDisconnected = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_DISCONNECTED, listener);
};
exports.onDisconnected = onDisconnected;
const onConnecting = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_CONNECTING, listener);
};
exports.onConnecting = onConnecting;
const onMessageUpdate = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_MESSAGE_UPDATED, listener);
};
exports.onMessageUpdate = onMessageUpdate;
const onPairingCode = (listener) => {
    callback.set(Defaults_1.CALLBACK_KEY.ON_MESSAGE_UPDATED, listener);
};
exports.onPairingCode = onPairingCode;
