// const whatsapp = require("wa-multi-session");
const whatsapp = require("../../dist/index");
const ValidationError = require("../../utils/error");
const { responseSuccessWithData } = require("../../utils/response");

exports.sendVoice = async (req, res, next) => {
  try {
    let to = req.body.to || req.query.to;
    let text = req.body.text || req.query.text;
    let isGroup = req.body.isGroup || req.query.isGroup;
    const sessionId = req.body.session || req.query.session || req.headers.session;
    if (!to || !text) throw new ValidationError("Missing Parameters");

    const receiver = to;
    if (!sessionId) throw new ValidationError("Session Not Founds");
    const send = await whatsapp.sendVoiceNote({
      sessionId,
      to: receiver,
      isGroup: !!isGroup,
      media : 'https://texttospeech.responsivevoice.org/v1/text:synthesize?text='+text+'&lang=id&engine=g3&name=&pitch=0.5&rate=0.5&volume=1&key=q276XkHv&gender=female',
      text,
    });

    res.status(200).json(
      responseSuccessWithData({
        id: send?.key?.id,
        status: send?.status,
        message: send?.message?.extendedTextMessage?.text || "Not Text",
        remoteJid: send?.key?.remoteJid,
      })
    );
  } catch (error) {
    next(error);
  }
};