// const whatsapp = require("wa-multi-session");
const whatsapp = require("../../dist/index");
const ValidationError = require("../../utils/error");
const { sendDocument } = require("../../dist/index");
const { responseSuccessWithData } = require("../../utils/response");
const { readFileSync } = require("fs");
const path = require("path");

exports.sendMessage = async (req, res, next) => {
  try {
    let to = req.body.to || req.query.to;
    let text = req.body.text || req.query.text;
    let isGroup = req.body.isGroup || req.query.isGroup;
    const sessionId =
      req.body.session || req.query.session || req.headers.session;

    if (!to || !text) throw new ValidationError("Missing Parameters");

    const receiver = to;
    if (!sessionId) throw new ValidationError("Session Not Founds");
    const send = await whatsapp.sendTextMessage({
      sessionId,
      to: receiver,
      isGroup: !!isGroup,
      text,
    });

    res.status(200).json(
      responseSuccessWithData({
        id: send?.key?.id,
        status: send?.status,
        message: send?.message?.extendedTextMessage?.text || "Not Text",
        remoteJid: send?.key?.remoteJid,
      })
    );
  } catch (error) {
    next(error);
  }
};

exports.sendFile = async (req, res, next) => {
  try {
    const to = req.body.to || req.query.to;
    const caption = req.body.caption || req.query.caption || "";
    const isGroup = req.body.isGroup || req.query.isGroup;
    const sessionId =
      req.body.session || req.query.session || req.headers.session;

    // Path file setelah upload
    const filePath = req.file ? req.file.path : null;

    if (!to || !filePath) throw new ValidationError("Missing Parameters");
    if (!sessionId) throw new ValidationError("Session Not Found");

    // Baca file dari server
    const fileBuffer = readFileSync(filePath);

    const response = await sendDocument({
      sessionId,
      to,
      isGroup: !!isGroup,
      media: fileBuffer,
      filename: path.basename(filePath), // Nama file
      text: caption, // Caption jika ada
    });

    res.status(200).json(
      responseSuccessWithData({
        id: response?.key?.id,
        status: response?.status,
        message: response?.message?.documentMessage?.fileName || "File Sent",
        remoteJid: response?.key?.remoteJid,
      })
    );
  } catch (error) {
    next(error);
  }
};

exports.sendBulkMessage = async (req, res, next) => {
  try {
    const sessionId =
      req.body.session || req.query.session || req.headers.session;
    const delay = req.body.delay || req.query.delay || req.headers.delay;
    if (!sessionId) {
      return res.status(400).json({
        status: false,
        data: {
          error: "Session Not Found",
        },
      });
    }
    res.status(200).json({
      status: true,
      data: {
        message: "Bulk Message is Processing",
      },
    });
    for (const dt of req.body.data) {
      const to = dt.to;
      const text = dt.text;
      const isGroup = !!dt.isGroup;

      await whatsapp.sendTextMessage({
        sessionId,
        to: to,
        isGroup: isGroup,
        text: text,
      });
      await whatsapp.createDelay(delay ?? 1000);
    }
    console.log("SEND BULK MESSAGE WITH DELAY SUCCESS");
  } catch (error) {
    next(error);
  }
};
