## Contributing Guidelines

Thank you for considering contributing to the `@mimamch/wa-gateway` library! We welcome your contributions and appreciate your support. To ensure a smooth collaboration process, please follow these guidelines when contributing to the project.

### Bug Reports and Feature Requests

If you encounter a bug or have a feature request, please open an issue on the [GitHub issue tracker](https://github.com/mimamch/cmd/issues). When reporting a bug, provide detailed information about the issue, including steps to reproduce it. For feature requests, clearly describe the new functionality you would like to see in the library.

### Pull Requests

We welcome pull requests for bug fixes, enhancements, and new features. Before submitting a pull request, please ensure that:

1. You have forked the repository and created a new branch for your changes.
2. Your code follows the project's coding style and conventions.
3. You have added appropriate tests to cover your changes.
4. All existing tests pass successfully.
5. Your commits are descriptive and include a clear explanation of the changes.

To submit a pull request, follow these steps:

1. Fork the repository on GitHub.
2. Clone your forked repository to your local machine.
3. Create a new branch for your changes: `git checkout -b my-feature`.
4. Make your changes and commit them: `git commit -m "Add new feature"`.
5. Push your branch to your forked repository: `git push origin my-feature`.
6. Open a pull request on the official repository's GitHub page.

### Development Setup

To set up the development environment and start working on the library, follow these steps:

1. Clone the repository: `git clone https://github.com/mimamch/cmd.git`.
2. Install the project dependencies: `npm install`.
3. Run tests to ensure everything is working: `npm test`.
4. Make your changes and add tests for them.
5. Run tests again to verify that everything is still working: `npm test`.
6. Commit your changes and push to your forked repository.
7. Open a pull request following the guidelines mentioned above.

### Code Style and Conventions

We strive to maintain a clean and consistent codebase. Please adhere to the following guidelines when contributing to the project:

- Use meaningful and descriptive variable and function names.
- Follow the existing code formatting and indentation style.
- Ensure your code is properly commented and documented.
- Write clear commit messages that explain the purpose of each commit.

### License

By contributing to this project, you agree that your contributions will be licensed under the MIT License. Make sure you understand and agree to the licensing terms before submitting your pull request.

### Code of Conduct

Please note that by participating in this project, you are expected to follow the [Code of Conduct](CODE_OF_CONDUCT.md). Be respectful and considerate towards others, and maintain a positive and inclusive environment for collaboration.

We appreciate your contributions and look forward to your involvement in improving the `@mimamch/wa-gateway` library!
